Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer


Private Type EVENTMSG
        message As Long
        paramL As Long
        paramH As Long
        time As Long
        hwnd As Long
End Type


Private Const WH_JOURNALPLAYBACK = 1
Private Const WH_JOURNALRECORD = 0

Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Private Const VK_CANCEL = &H3
Private Const WM_KEYDOWN = &H100
Private Const VK_F10 = &H79

Private hRecordHook As Long
Private hPlaybackHook As Long
Private MsgArray() As Long
Private StartTime As Long
Private CurrMSG As Long

Public IsHooked As Boolean
Public IsPBHooked As Boolean


Public Sub init()
    ReDim MsgArray(6, 1) As Long
End Sub


'-----------------------------
' RECORDING
'-----------------------------
Public Sub SetJournalHook()
    If IsHooked Then
        MsgBox "Don't hook it twice without unhooking or you will be unable to unhook it."
    Else
        StartTime = GetTickCount
        
        hRecordHook = SetWindowsHookEx(WH_JOURNALRECORD, AddressOf JournalProc, App.hInstance, 0)
        
        IsHooked = True
    End If
End Sub

Public Sub RemoveJournalHook()
    Dim lRetVal As Long
    lRetVal = UnhookWindowsHookEx(hRecordHook)
    IsHooked = False
End Sub


Public Function JournalProc(ByVal uCode As Long, ByVal wParam As Long, lParam As EVENTMSG) As Long
    'Debug.Print "[" & uCode & "] " & lParam.message & " : " & lParam.hwnd & " : " & lParam.paramH & " : " & lParam.paramL & " : " & lParam.time

    If uCode = HC_ACTION Then
        If lParam.message = WM_KEYDOWN And GetLowByte(lParam.paramL) = VK_CANCEL Then
            Call RemoveJournalHook
        End If
        MsgArray(0, UBound(MsgArray, 2)) = uCode
        MsgArray(1, UBound(MsgArray, 2)) = lParam.message
        MsgArray(2, UBound(MsgArray, 2)) = lParam.hwnd
        MsgArray(3, UBound(MsgArray, 2)) = lParam.paramH
        MsgArray(4, UBound(MsgArray, 2)) = lParam.paramL
        MsgArray(5, UBound(MsgArray, 2)) = (lParam.time - StartTime)
        
        ReDim Preserve MsgArray(6, (UBound(MsgArray, 2) + 1)) As Long
    ElseIf uCode = HC_SYSMODALON Then
        'Skip recording
    ElseIf uCode = HC_SYSMODALOFF Then
        'Skip recording
    End If
    
    JournalProc = CallNextHookEx(hRecordHook, uCode, wParam, lParam)
End Function

Public Function GetLowByte(ByRef lValue As Long) As Long
   GetLowByte = (lValue And &HFF&)
End Function


'-----------------------------
' PLAYBACK
'-----------------------------
Public Sub SetPlaybackHook()
    If IsPBHooked Or IsPBHooked Then
        MsgBox "Don't hook it twice without unhooking or you will be unable to remove the hook."
    Else
        StartTime = GetTickCount
        CurrMSG = 1
        
        hPlaybackHook = SetWindowsHookEx(WH_JOURNALPLAYBACK, AddressOf JournalPlaybackProc, App.hInstance, 0)

        IsPBHooked = True
    End If
End Sub

Public Sub RemovePlaybackHook()
    Dim lRetVal As Long
    lRetVal = UnhookWindowsHookEx(hPlaybackHook)
    IsPBHooked = False
End Sub


Public Function JournalPlaybackProc(ByVal uCode As Long, ByVal wParam As Long, lParam As EVENTMSG) As Long
    If uCode = HC_GETNEXT Then       'You should play the current message
        If CurrMSG >= UBound(MsgArray, 2) Then
            'No more messages to play, remove the hook and restore control to the user gracefully
            Call RemovePlaybackHook
        Else
            lParam.message = MsgArray(1, CurrMSG)
            lParam.hwnd = MsgArray(2, CurrMSG)
            lParam.paramH = MsgArray(3, CurrMSG)
            lParam.paramL = MsgArray(4, CurrMSG)
            lParam.time = MsgArray(5, CurrMSG) - MsgArray(5, CurrMSG - 1)  'StartTime + MsgArray(5, CurrMSG)

            JournalPlaybackProc = MsgArray(5, CurrMSG) - MsgArray(5, CurrMSG - 1)
            
            'Debug.Print JournalPlaybackProc & "                  " & lParam.time & "         L: " & LastMSG & "         C: " & CurrMSG
            
            Form2.Caption = "[" & uCode & "] " & lParam.message & " : " & lParam.hwnd & " : " & lParam.paramH & " : " & lParam.paramL & " : " & lParam.time
        End If
    ElseIf uCode = HC_SKIP Then      'You should retrieve the next message
        If CurrMSG >= UBound(MsgArray, 2) Then
            'No more messages to play, remove the hook and restore control to the user gracefully
            Call RemovePlaybackHook
        End If
            
        CurrMSG = CurrMSG + 1
    ElseIf uCode = HC_NOREMOVE Then
        'Skip Playback - an app has called PeekMessage.
    ElseIf uCode = HC_SYSMODALON Then
        'Skip playback
    ElseIf uCode = HC_SYSMODALOFF Then
        'Skip playback
    End If
    
    JournalPlaybackProc = CallNextHookEx(hPlaybackHook, uCode, wParam, lParam)
End Function

